local orig_chk_attack = PlayerStandard._check_action_primary_attack
local luck = 0.5
local current_wpn_dmg = 0.5

function PlayerStandard:_check_action_primary_attack(t, input,...)
    local has_one = managers.player:has_category_upgrade("player","chance_change_one")
	local has_svn = managers.player:has_category_upgrade("player","chance_change_seven")
	
    if has_one and input.btn_primary_attack_state then
        local chance = math.random()
		local weap_unit = self._equipped_unit

		if alive(weap_unit) then
			local weap_base = weap_unit:base()
			local fire_mode = weap_base:fire_mode()
			local action_forbidden = self:_is_reloading() or self:_changing_weapon() or self:_is_meleeing() or self._use_item_expire_t or self:_interacting() or self:_is_throwing_projectile() or self:_is_deploying_bipod() or self._menu_closed_fire_cooldown > 0 or self:is_switching_stances()
			if not action_forbidden then
				if (fire_mode == "single" and input.btn_primary_attack_press) or (fire_mode == "auto" and input.btn_primary_attack_state) then
					if chance > luck then
						if has_svn and luck > 0.21 then
							luck = luck - 0.05
						end
						if current_wpn_dmg < 500 then
							current_wpn_dmg = current_wpn_dmg * 2
						end
						return orig_chk_attack(self, t, input, ...)
					else
						luck = 0.5
						current_wpn_dmg = 0.5
						local dmg_ext = self._unit:character_damage()
						if dmg_ext and weap_base:start_shooting_allowed() then
							weap_base:update_next_shooting_time()
							
							local damage = weap_base._damage / 10
							dmg_ext:damage_simple({
								variant = "bullet",
								damage = damage
							})
						end
						
						-- tell the game that you are not firing the weapon
						return false
					end
                end
            end
        end
    else
		return orig_chk_attack(self, t, input, ...)
    end
end

local orig_damage = RaycastWeaponBase._get_current_damage
function RaycastWeaponBase:_get_current_damage(...)
	local bonus_damage = 1
	local pm = managers.player
    
	if pm:has_category_upgrade("player","chance_change_three") then 
		bonus_damage = current_wpn_dmg
	end
	return orig_damage(self,...) * bonus_damage
end
